﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.HL7.ITS;
using System.Runtime.Serialization;

namespace BMS.Facade.Data
{
    /// <summary>
    /// Transfer class. Stores information about transfer.
    /// </summary>
    [DataContract]
    public class Transfer : Act
    {
        #region Public Members

        /// <summary>
        /// Gets or sets the facility to.
        /// </summary>
        /// <value>
        /// The facility to.
        /// </value>
        [ConvertDateTime]
        [DataMember]
        public Facility FacilityTo { get; set; }

        /// <summary>
        /// Gets or sets the facility from.
        /// </summary>
        /// <value>
        /// The facility from.
        /// </value>
        [ConvertDateTime]
        [DataMember]
        public Facility FacilityFrom { get; set; }

        /// <summary>
        /// Gets or sets the contract.
        /// </summary>
        /// <value>
        /// The contract.
        /// </value>
        [DataMember]
        public CD Contract { get; set; }

        /// <summary>
        /// Gets or sets the diagnosis.
        /// </summary>
        /// <value>
        /// The diagnosis.
        /// </value>
        [DataMember]
        public string Diagnosis { get; set; }

        /// <summary>
        /// Gets or sets the patient's current location or community hospital.
        /// </summary>
        /// <value>
        /// The current location.
        /// </value>
        [DataMember]
        public string CurrentLocation { get; set; }

        /// <summary>
        /// Gets or sets the comment.
        /// </summary>
        /// <value>
        /// The comment.
        /// </value>
        [DataMember]
        public string Comment { get; set; }

        /// <summary>
        /// Gets or sets the disposition.
        /// </summary>
        /// <value>
        /// The disposition.
        /// </value>
        [DataMember]
        public CD Disposition { get; set; }

        /// <summary>
        /// Gets or sets the era (battle field).
        /// </summary>
        /// <value>
        /// The era.
        /// </value>
        [DataMember]
        public CD Era { get; set; }

        /// <summary>
        /// Gets or sets the disposition date.
        /// </summary>
        /// <value>
        /// The disposition date.
        /// </value>
        [DataMember]
        public DateTime? DispositionDate { get; set; }

        /// <summary>
        /// Gets or sets the discharge comment.
        /// </summary>
        /// <value>
        /// The discharge comment.
        /// </value>
        [DataMember]
        public string DischargeComment { get; set; }

        /// <summary>
        /// Gets or sets the speciality.
        /// </summary>
        /// <value>
        /// The speciality.
        /// </value>
        [DataMember]
        public CD Speciality { get; set; }

        /// <summary>
        /// Gets or sets the admission date.
        /// </summary>
        /// <value>
        /// The admission date.
        /// </value>
        [DataMember]
        public DateTime? AdmissionDate { get; set; }

        /// <summary>
        /// Gets or sets the person that created the transfer.
        /// </summary>
        /// <value>
        /// The person that created the transfer.
        /// </value>
        [DataMember]
        public string EnteredBy { get; set; }

        /// <summary>
        /// Gets or sets the person that last edited the transfer.
        /// </summary>
        /// <value>
        /// The person that last edited the transfer.
        /// </value>
        [DataMember]
        public string LastEditBy { get; set; }

        /// <summary>
        /// Gets or sets the date and time when the transfer was last edited.
        /// </summary>
        /// <value>
        /// The date and time when the transfer was last edited.
        /// </value>
        [DataMember]
        public DateTime? Edited { get; set; }

        /// <summary>
        /// Gets or sets the requested date.
        /// </summary>
        /// <value>
        /// The requested date.
        /// </value>
        [DataMember]
        public DateTime? RequestedDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is national wait list.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is national wait list; otherwise, <c>false</c>.
        /// </value>
        [DataMember]
        public bool IsNationalWaitList { get; set; }

        /// <summary>
        /// Gets or sets the type of bed or ward needed by the patient(EVS patient).
        /// </summary>
        /// <value>
        /// The type of bed ward.
        /// </value>
        [DataMember]
        public string TypeOfBedWard { get; set; }

        [DataMember]
        public bool IsFee { get; set; }

        [DataMember]
        public string TransferCoordinator { get; set; }

        [DataMember]
        public string TransferCoordinatorPhone { get; set; }

        #endregion
    }
}
